/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import dan200.computercraft.shared.recipe.ShapedTemplate;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CustomShapedRecipe
extends ShapedRecipe {
    private final ItemStack result;

    public CustomShapedRecipe(ResourceLocation id, ShapedRecipeSpec recipe) {
        super(id, recipe.properties().group(), recipe.properties().category(), recipe.template().width(), recipe.template().height(), recipe.template().ingredients(), recipe.result());
        this.result = recipe.result();
    }

    public final ShapedRecipeSpec toSpec() {
        return new ShapedRecipeSpec(RecipeProperties.of((CraftingRecipe)this), ShapedTemplate.of(this), this.result);
    }

    public RecipeSerializer<? extends CustomShapedRecipe> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.SHAPED.get();
    }

    public static <T extends CustomShapedRecipe> RecipeSerializer<T> serialiser(Factory<T> factory) {
        return new Serialiser((id, r) -> DataResult.success((Object)((Object)((CustomShapedRecipe)((Object)((Object)factory.create(id, r)))))));
    }

    public static <T extends CustomShapedRecipe> RecipeSerializer<T> validatingSerialiser(Factory<DataResult<T>> factory) {
        return new Serialiser<T>(factory);
    }

    private record Serialiser<T extends CustomShapedRecipe>(Factory<DataResult<T>> factory = (id, r) -> ((DataResult)factory.create(id, r)).flatMap(x -> {
        if (x.m_7707_() != this) {
            return DataResult.error(() -> "Expected serialiser to be " + String.valueOf(this) + ", but was " + String.valueOf(x.m_7707_()));
        }
        return DataResult.success((Object)x);
    })) implements RecipeSerializer<T>
    {
        public T fromJson(ResourceLocation id, JsonObject json) {
            return (T)((Object)((CustomShapedRecipe)((Object)Util.m_260975_(this.factory.create(id, ShapedRecipeSpec.fromJson(json)), JsonParseException::new))));
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return (T)((Object)((CustomShapedRecipe)((Object)Util.m_260975_(this.factory.create(id, ShapedRecipeSpec.fromNetwork(buffer)), IllegalStateException::new))));
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((CustomShapedRecipe)((Object)recipe)).toSpec().toNetwork(buffer);
        }
    }

    public static interface Factory<R> {
        public R create(ResourceLocation var1, ShapedRecipeSpec var2);
    }
}

